package com.baidu.nlp.conversation.demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.baidu.nlp.conversation.demo.settings.SimpleTextAdapter;
import com.baidu.nlp.conversation.demo.settings.SimpleTextDialog;
import com.baidu.nlp.conversation.demo.settings.SpeakerBean;

import java.util.ArrayList;

public class SettingsActivity extends Activity implements View.OnClickListener {
    private static final String TAG = Config.TAG + SettingsActivity.class.getSimpleName();
    public static final String PREF_SETTINGS = "settings";
    public static final String KEY_TTS_PERSON = "tts_person";
    private LinearLayout lltTTSBasicPerson;
    private TextView txtTtsBasicPerson;
    private TextView txtTtsCurrentPerson;
    private SimpleTextAdapter simpleTextAdapter;

    private ArrayList<SpeakerBean> timbreList = new ArrayList<>();

    private SharedPreferences mSharedPreferences;

    public static void start(Context context) {
        Intent intent = new Intent(context, SettingsActivity.class);
        context.startActivity(intent);
    }

    public static void start(Activity activity, int requestCode) {
        Intent intent = new Intent(activity, SettingsActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i(TAG, "onCreate");
        setContentView(R.layout.activity_settings);
        initData();
        initView();
        fillData();
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.i(TAG, "onResume");
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.i(TAG, "onPause");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.i(TAG, "onDestroy");
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.llt_tts_basic_person:
                txtTtsBasicPerson.performClick();
                SimpleTextDialog simpleTextDialog = new SimpleTextDialog(this);
                simpleTextDialog.setDataList(timbreList);
                simpleTextAdapter = simpleTextDialog.getAdapter();
                View inflate = LayoutInflater.from(this).inflate(R.layout.simple_text, null);
                simpleTextAdapter.setOnItemSelectedListener(new SimpleTextAdapter.OnItemSelectedListener() {
                    @Override
                    public void onSelected(SpeakerBean bean) {
                        txtTtsCurrentPerson.setText(bean.name);
                        mSharedPreferences.edit().putInt(KEY_TTS_PERSON, bean.code).commit();
                        Config.sTtsPerson = bean.code;
                        simpleTextDialog.dismiss();
                    }
                });
                simpleTextDialog.dismiss();
                simpleTextDialog.show();
                break;
            default:
                break;
        }
    }

    private void initData() {
        timbreList.clear();
        timbreList.add(new SpeakerBean("度小宇", 1));
        timbreList.add(new SpeakerBean("度小美", 0));
        timbreList.add(new SpeakerBean("度逍遥（基础）", 3));
        timbreList.add(new SpeakerBean("度丫丫", 4));
    }

    private void initView() {
        lltTTSBasicPerson = findViewById(R.id.llt_tts_basic_person);
        txtTtsBasicPerson = findViewById(R.id.txt_tts_basic_person);
        txtTtsCurrentPerson = findViewById(R.id.txt_tts_current_person);

        lltTTSBasicPerson.setOnClickListener(this);
    }

    private void fillData() {
        mSharedPreferences = getSharedPreferences(PREF_SETTINGS, MODE_PRIVATE);
        int currentTtsPerson = mSharedPreferences.getInt(KEY_TTS_PERSON, Config.sTtsPerson);
        for (SpeakerBean speakerbean : timbreList) {
            if (currentTtsPerson == speakerbean.code) {
                txtTtsCurrentPerson.setText(speakerbean.name);
            }
        }
    }
}
