package com.baidu.nlp.conversation.demo.settings;

import android.content.Context;
import android.os.Bundle;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.baidu.nlp.conversation.demo.R;

import java.util.List;

/**
 * 简单的选项对话框，每个条目只有一个TextView以及一个ImageView的对话框
 */
public class SimpleTextDialog extends BaseDialog {

    private RecyclerView recyclerView;
    private SimpleTextAdapter adapter;

    public SimpleTextDialog(Context context) {
        super(context);
        adapter = new SimpleTextAdapter();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dialog_simple_text);
        recyclerView = findViewById(R.id.recycler_simple_text);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayoutManager.VERTICAL, false));
        recyclerView.setAdapter(adapter);
    }

    public void setDataList(List<SpeakerBean> dataList) {
        if (adapter == null) {
            return;
        }
        adapter.setDataList(dataList);
    }

    public SimpleTextAdapter getAdapter() {
        return adapter;
    }
}
