package com.baidu.nlp.conversation.demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.PixelFormat;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;

import com.baidu.aip.vdh.SpeakerConf;
import com.baidu.aip.vdh.VirtualFactory;
import com.baidu.aip.vdh.beans.DisplayMode;
import com.baidu.aip.vdh.beans.Model;
import com.baidu.aip.vdh.beans.VirtualHumanDataBean;
import com.baidu.aip.vdh.core.player.PlayTxtResult;
import com.baidu.aip.vdh.player.Player;
import com.baidu.aip.vdh.utils.FileUtils;
import com.baidu.aip.vdh.utils.PcmNoiseSuppressor;
import com.baidu.aip.vdh.utils.VirtualModelUtil;
import com.baidu.nlp.conversation.demo.utils.GLRenderer;
import com.baidu.nlp.conversation.demo.utils.TimeUtils;

import java.util.ArrayList;
import java.util.List;

public class FrameDataActivity extends Activity {
    public static final String KEY_USEOUTPLAY = FrameDataActivity.class.getName() + "KEY_USEOUTPLAY";
    private static final String TAG = Config.TAG + FrameDataActivity.class.getSimpleName();
    private int useVirtualId = Config.CONFIG_VISUALIZE;
    private static final int REQ_SETTINGS = 1000;
    private boolean isUseOutPlay = false;
    private String pcmPath = "/sdcard/baidu/aip/face_virtual/";

    private Context mContext;
    private Player player;
    private List<Model> virtualModels = new ArrayList<>();
    private TextView mFpsTxt;
    private long fps;
    private GLSurfaceView mGLSurfaceView;
    private GLRenderer mRenderer;

    private Button settingsBtn = null;
    private Button checkModelBtn = null;
    private Button modeSwitchBtn = null;
    private Button flowPlayBtn = null;
    private LinearLayout flowPlayLl = null;
    private Button btnUpdateTts = null;
    private Button spUpdateTts = null;
    private LinearLayout commPlayLl = null;
    private Button pauseResumeBtn = null;
    private Button insertPlayBtn = null;
    private EditText inputTtsIdEt;
    private EditText inputTtsKeyEt;
    int changeCount = 0;
    private int lastTtsPerson;

    private SeekBar sebVolume = null;

    enum PlayMode {
        COMMON,
        FLOW
    }

    PlayMode playMode = PlayMode.COMMON;

    private AlertDialog updateTtsDialog;

    private SharedPreferences mSharedPreferences;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        isUseOutPlay = getIntent().getBooleanExtra(KEY_USEOUTPLAY, false);
        // 去除标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // 去除状态栏
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        mContext = this;
        setContentView(R.layout.activity_frame_data);

        mSharedPreferences = getSharedPreferences(Config.PREF_APP_ACCOUNT, MODE_PRIVATE);
        // 显示数字人sdk版本信息
        TextView sdkInfo = findViewById(R.id.sdk_info);
        sdkInfo.setText(com.baidu.aip.vdh.Config.VER + "\n" + com.baidu.aip.vdh.Config.VER_CORE + "\n"
                + VirtualFactory.getEngine().getSdkStatus(FrameDataActivity.this));
        mFpsTxt = findViewById(R.id.fps_txt);

        // 数字子显示view
        initView();
        // 初始化播报
        initPlayer();
        // 初始化形象模型
        initModelsData();
        setActions();
    }

    /**
     * 初始化模型数据
     */
    private void initModelsData() {
        // 注：第二个参数figureId为人像资源ID，第三方人像资源必须传非null值，只有内置的默认人像（目前是20）可以传null。该值是调用生成人像的API接口返回的。
        virtualModels.add(new Model(20, null));
        virtualModels.add(new Model(26, "6505629967f58cf527ff766c"));
    }

    /**
     * 展示数字人以及初始化player
     */
    private void initPlayer() {
        // 1:初始化player
        player = VirtualFactory.getPlayer(mContext);
        // 4: 设置数字人模型
        Model model = new Model(useVirtualId);
        model.setCloseAudio(true);
        DisplayMode displayMode = new DisplayMode();
        displayMode.setDataMode(DisplayMode.DataMode.FRAME_ONLY);
        player.setVirtualModel(model, displayMode, (msgType, msgSubType, msg) -> {
            String showMsg = "msgType:" + msgType + " "
                    + "msgSubType:" + msgSubType + " "
                    + "msg:" + msg;
            Log.i(TAG, "setVirtualModel:" + showMsg);
            Toast.makeText(mContext, "setVirtualModel:" + showMsg, Toast.LENGTH_SHORT).show();
        });
        player.setDisplay(null, 720, 1280);
        // 3: 添加回调
        player.addCallback(new Player.Callback() {
            @Override
            public void onVirtualHumanStart() {
                Log.v(TAG, "onVirtualHumanStart");
                Toast.makeText(mContext, "onVirtualHumanStart", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanFinish() {
                Log.v(TAG, "onVirtualHumanFinish");
                // 播报结束，暂停按钮恢复正常状态

                Toast.makeText(mContext, "onVirtualHumanFinish", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanData(VirtualHumanDataBean frameBean) {
                processData(frameBean);
            }

            @Override
            public void onRemainBuffer(int remainBytes, int remainInsertBytes) {
            }

            @Override
            public void onPcmVolumeError(int code, String message, float vol) {

            }

            @Override
            public void onVirtualHumanPause() {
                Log.v(TAG, "onVirtualHumanPause");
                Toast.makeText(mContext, "onVirtualHumanPause", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onError(int code, int subCode, String msg) {
                String showMsg = "error: code:" + code + " subCode:" + subCode + " msg:" + msg;
                Log.e(TAG, showMsg);
                FrameDataActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_SHORT).show());
            }
        });

    }

    private void processData(VirtualHumanDataBean virtualHumanDataBean) {
        fps = virtualHumanDataBean.getFps();
        runOnUiThread(runnable);
        // 音频数据处理
        byte[] audioStreams = virtualHumanDataBean.getAudioStreams();
        if (audioStreams != null && audioStreams.length > 0) {
            PcmPlayerUtil.getInstance().start(audioStreams, 0, audioStreams.length);
        }
        if (virtualHumanDataBean.getVideoStreams() != null) {
            if (mRenderer != null) {
                mRenderer.updateTextureData(virtualHumanDataBean.getVideoStreams(), 720, 1280);
                mGLSurfaceView.requestRender();
            }
        }
    }

    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            mFpsTxt.setText("帧率： " + fps);
        }
    };

    /**
     * 初始化按钮
     */
    private void initView() {
        mGLSurfaceView = findViewById(R.id.gl_surface_view);
        mRenderer = new GLRenderer();
        mGLSurfaceView.setEGLContextClientVersion(2);
        mGLSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0); // 设置EGL配置参数
        mGLSurfaceView.getHolder().setFormat(PixelFormat.TRANSLUCENT);
        mGLSurfaceView.setZOrderOnTop(true);
        mGLSurfaceView.setRenderer(mRenderer);
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    private void setActions() {
        // 播放本地pcm文件
        findViewById(R.id.play_pcm_file).setOnClickListener(view -> startPlayFile());
        // 打断播报
        findViewById(R.id.recognize_interrupted).setOnClickListener(v -> interrupt());
        // 播放文本
        findViewById(R.id.play_text).setOnClickListener(v -> startPlayText());

        // 播放长文本
        findViewById(R.id.play_long_txt).setOnClickListener(v -> startPlayLongText());

        findViewById(R.id.check_virtual_character).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                player.virtualModelCheck(new Model(35, "650565da67f58cf527ff766d"), new Player.VirtualModelCheckCallback() {
                    @Override
                    public void onVirtualModelCheckStatus(int code, int subCode, String msg) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("code:");
                        stringBuffer.append(code);
                        stringBuffer.append("   subcode:");
                        stringBuffer.append(subCode);
                        stringBuffer.append("   msg:");
                        stringBuffer.append(msg);
                        Log.e("AipHuman", stringBuffer.toString());
                        Toast.makeText(FrameDataActivity.this, stringBuffer.toString(), Toast.LENGTH_SHORT).show();

                    }
                });
            }
        });
        // 开始插播
        insertPlayBtn = findViewById(R.id.play_insert_start_btn);
        insertPlayBtn.setTag(false);
        insertPlayBtn.setOnClickListener(v -> {
            boolean isInsert = (boolean) insertPlayBtn.getTag();
            isInsert = !isInsert;
            if (isInsert) {
                if (player.speakInsertFlowPcmStart(mContext)) {
                    insertPlayBtn.setText(R.string.play_insert_stop_txt);
                    insertPlayBtn.setTag(isInsert);
                    return;
                }
            } else {
                if (player.speakInsertFlowPcmFinish(mContext, true)) {
                    insertPlayBtn.setText(R.string.play_insert_start_txt);
                    insertPlayBtn.setTag(isInsert);
                    return;
                }
            }
            runOnUiThread(() -> Toast.makeText(FrameDataActivity.this, "请在流式模式下切换！", Toast.LENGTH_LONG).show());
        });
        // 插入播报
        findViewById(R.id.play_insert_pcm_btn).setOnClickListener(v -> playInserPcm());
        // 插播pcm
        findViewById(R.id.play_insert_txt_btn).setOnClickListener(v -> playInsertTxt());

        // 切换人物形象
        findViewById(R.id.change_virtual_character).setOnClickListener(v -> changeCharacter());

        findViewById(R.id.release).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        flowPlayLl = findViewById(R.id.lllayou_left_play_flow);
        commPlayLl = findViewById(R.id.lllayou_left_play_comm);

        btnUpdateTts = findViewById(R.id.btn_update_tts);
        settingsBtn = findViewById(R.id.settings_btn);
        checkModelBtn = findViewById(R.id.check_model_btn);
        // 播报模式
        modeSwitchBtn = findViewById(R.id.play_mode_btn);
        modeSwitchBtn.setTag(PlayMode.COMMON);
        switchPlayMode(PlayMode.COMMON);
        if (modeSwitchBtn.getTag() == PlayMode.COMMON) {
            insertPlayBtn.setVisibility(View.GONE);
        }
        btnUpdateTts.setOnClickListener(v -> {
            showUpdateTtsDialog();
        });
        settingsBtn.setOnClickListener(v -> {
            Log.i(TAG, "settingsBtn onClick");
            if (player.isPlaying() && modeSwitchBtn.getTag() == PlayMode.COMMON) {
                settingsBtn.setEnabled(false);
            }
            lastTtsPerson = Config.sTtsPerson;
            SettingsActivity.start(FrameDataActivity.this, REQ_SETTINGS);
        });

        checkModelBtn.setOnClickListener(v -> {
            Log.i(TAG, "checkModelBtn onClick");
            Model model = new Model(35, "650565da67f58cf527ff766d");
            VirtualModelUtil.checkModel(model, (figureId, code, subCode, msg) -> {
                String compositeMsg = "[checkModel]: figureId:" + figureId
                        + " msgType:" + code + " msgSubType:" + subCode + " msg:" + msg;
                Log.i(TAG, compositeMsg);
                runOnUiThread(() -> Toast.makeText(FrameDataActivity.this, compositeMsg, Toast.LENGTH_LONG).show());
            });
        });

        modeSwitchBtn.setOnClickListener(v -> {
            if (player.isPlaying()) {
                Toast.makeText(mContext, "正在播报中，不能切换播报模式~", Toast.LENGTH_SHORT).show();
                return;
            }
            if (player.isPause()) {
                Toast.makeText(mContext, "处于暂停状态，不能切换播报模式~", Toast.LENGTH_SHORT).show();
                return;
            }
            PlayMode mode = (PlayMode) modeSwitchBtn.getTag();
            if (mode == PlayMode.COMMON) {
                mode = PlayMode.FLOW;
                insertPlayBtn.setVisibility(View.VISIBLE);
            } else if (mode == PlayMode.FLOW) {
                mode = PlayMode.COMMON;
                insertPlayBtn.setVisibility(View.GONE);
            }
            switchPlayMode(mode);
            modeSwitchBtn.setTag(mode);
        });

        // 播报：暂停，继续
        pauseResumeBtn = findViewById(R.id.play_pause_resume);
        pauseResumeBtn.setOnClickListener(v -> {
            if (player.isPlaying()) {
                player.pausePlay();
                pauseResumeBtn.setText(R.string.play_resume_txt);
            } else if (player.isPause()) {
                player.resumePlay();
                pauseResumeBtn.setText(R.string.play_pause_txt);
            }
        });

        // 流式播放
        flowPlayBtn = findViewById(R.id.play_flow_start_btn);
        flowPlayBtn.setOnClickListener(v -> flowPlayStartStop()); // 流式开始&结束
        findViewById(R.id.play_flow_pcm_btn).setOnClickListener(v -> flowPlayFlowPcm()); // 以pcm的流持续驱动
        findViewById(R.id.play_flow_txt_btn).setOnClickListener(v -> flowPlayFlowTxt()); // 以txt的流持续驱动

        // 显示数字人sdk版本信息
        TextView sdkInfo = findViewById(R.id.sdk_info);
        sdkInfo.setText(com.baidu.aip.vdh.Config.VER + "\n" + com.baidu.aip.vdh.Config.VER_CORE + "\n"
                + VirtualFactory.getEngine().getSdkStatus(FrameDataActivity.this));

        sebVolume = findViewById(R.id.seekBar_volume);
        sebVolume.setMax(10);
        sebVolume.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                if (player != null) {
                    player.setPcmVolume(i);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        // 显示实时时间
        new TimeUtils(findViewById(R.id.time_text)).start();
    }

    private void showUpdateTtsDialog() {
        if (updateTtsDialog == null) {
            View view = LayoutInflater.from(FrameDataActivity.this).inflate(R.layout.dialog_update_tts, null);
            updateTtsDialog = new AlertDialog.Builder(FrameDataActivity.this)
                    .setView(view)
                    .show();

            inputTtsIdEt = view.findViewById(R.id.sp_input_tts_id_et);
            inputTtsKeyEt = view.findViewById(R.id.sp_input_tts_key_et);
            if (TextUtils.isEmpty(Config.sTtsId)) {
                Config.sTtsId = mSharedPreferences.getString(Config.KEY_TTS_ID, "");
            }
            if (TextUtils.isEmpty(Config.sTtsKey)) {
                Config.sTtsKey = mSharedPreferences.getString(Config.KEY_TTS_KEY, "");
            }
            inputTtsIdEt.setText(Config.sTtsId);
            inputTtsKeyEt.setText(Config.sTtsKey);
            inputTtsIdEt.setSelection(inputTtsIdEt.getText().length());
            inputTtsKeyEt.setSelection(inputTtsKeyEt.getText().length());
            spUpdateTts = view.findViewById(R.id.sp_update_tts);
            spUpdateTts.setOnClickListener(v -> {
                sdkUpdateTts();
            });
        } else {
            if (TextUtils.isEmpty(Config.sTtsId)) {
                Config.sTtsId = mSharedPreferences.getString(Config.KEY_TTS_ID, "");
            }
            if (TextUtils.isEmpty(Config.sTtsKey)) {
                Config.sTtsKey = mSharedPreferences.getString(Config.KEY_TTS_KEY, "");
            }
            inputTtsIdEt.setText(Config.sTtsId);
            inputTtsKeyEt.setText(Config.sTtsKey);
            inputTtsIdEt.setSelection(inputTtsIdEt.getText().length());
            inputTtsKeyEt.setSelection(inputTtsKeyEt.getText().length());
            updateTtsDialog.show();
        }
    }

    private void hideUpdateTtsDialog() {
        updateTtsDialog.hide();
    }

    private void sdkUpdateTts() {
        String ttsId = inputTtsIdEt.getText().toString().trim();
        String ttsKey = inputTtsKeyEt.getText().toString().trim();
        if (TextUtils.isEmpty(ttsId)) {
            Toast.makeText(mContext, "请输入有效的: ttsId", Toast.LENGTH_LONG).show();
            return;
        }
        if (TextUtils.isEmpty(ttsKey)) {
            Toast.makeText(mContext, "请输入有效的: ttsKey", Toast.LENGTH_LONG).show();
            return;
        }
        VirtualFactory.getEngine().updateTtsParam(ttsId, ttsKey);
        if (!TextUtils.isEmpty(ttsId)) {
            mSharedPreferences.edit().putString(Config.KEY_TTS_ID, ttsId).commit();
        }
        if (!TextUtils.isEmpty(ttsKey)) {
            mSharedPreferences.edit().putString(Config.KEY_TTS_KEY, ttsKey).commit();
        }
        Config.sTtsId = ttsId;
        Config.sTtsKey = ttsKey;
        inputTtsIdEt.getText().clear();
        inputTtsKeyEt.getText().clear();
        hideUpdateTtsDialog();
    }

    /**
     * 切换播报模式
     *
     * @param mode
     */
    private void switchPlayMode(PlayMode mode) {
        if (mode == PlayMode.FLOW) {
            flowPlayLl.setVisibility(View.VISIBLE);
            commPlayLl.setVisibility(View.GONE);
            modeSwitchBtn.setText("模式：流式播放");
        } else if (mode == PlayMode.COMMON) {
            flowPlayLl.setVisibility(View.GONE);
            commPlayLl.setVisibility(View.VISIBLE);
            modeSwitchBtn.setText("模式：普通播放");
        }
        playMode = mode;
    }

    @Override
    protected void onResume() {
        Log.i(TAG, "onResume");
        player.onResume();
        super.onResume();
    }

    @Override
    protected void onPause() {
        player.onPause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        player.release();
        if (isUseOutPlay) {
            PcmPlayerUtil.getInstance().release();
        }
        PcmNoiseSuppressor.getInstance().release();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.i(TAG, "onActivityResult, requestCode:" + requestCode + ", resultCode:" + resultCode);
        switch (requestCode) {
            case REQ_SETTINGS:
                if (resultCode == RESULT_CANCELED) {
                    boolean isTtsPersonChanged = lastTtsPerson != Config.sTtsPerson;
                    Log.i(TAG, "onActivityResult, isTtsPersonChanged:" + isTtsPersonChanged);
                    if (isTtsPersonChanged) {
                        Toast.makeText(this, "修改音色库只对下次的文本驱动生效", Toast.LENGTH_LONG).show();
                    }
                }
                break;
            default:
                break;
        }
    }

    Thread pcmFlowThread = null;
    Object pcmFlowLock = new Object();

    Thread txtFlowThread = null;
    Object txtFlowLock = new Object();

    /**
     * 流式播报开始
     */
    private void flowPlayStartStop() {
        if (!player.isPlaying() && !player.isPause()) {
            // 流式播报的情况下，播放中，和暂停，都属于在播报
            player.speakFlowStart(mContext, true);
            flowPlayBtn.setText(R.string.play_flow_finish);
            Toast.makeText(mContext, "流式播报开始!", Toast.LENGTH_SHORT).show();
        } else {
            player.speakFlowFinish(mContext);
            flowPlayBtn.setText(R.string.play_flow_start);
            Toast.makeText(mContext, "流式播报结束！", Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 以pcm持续驱动数字人
     */
    private void flowPlayFlowPcm() {
        synchronized (pcmFlowLock) {
            if (pcmFlowThread != null) {
                Toast.makeText(mContext, "pcm流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (txtFlowLock) {
            if (txtFlowThread != null) {
                Toast.makeText(mContext, "txt流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (pcmFlowLock) {
            pcmFlowThread = new Thread(() -> {
                byte[] data = FileUtils.getByte(pcmPath + "input/1_16.pcm");
                int offset = 0;
                while (true) {
                    int count = 32000;
                    if (offset + count >= data.length) {
                        count = data.length - offset;
                    }

                    if (count <= 0) {
                        break;
                    }
                    Log.i(TAG, "count:" + count);

                    byte[] tmp = new byte[count];
                    System.arraycopy(data, offset, tmp, 0, count);
                    offset += count;
                    boolean isOk = player.speakFlowOnPcm(mContext, tmp);
                    if (!isOk) {
                        FrameDataActivity.this.runOnUiThread(() -> Toast.makeText(mContext,
                                "音频驱动失败: 'buffer已满'或者'数字人没有进行播放'！",
                                Toast.LENGTH_SHORT).show());
                        break;
                    }
                }

                Log.i(TAG, "flow thread finish");
                synchronized (pcmFlowLock) {
                    pcmFlowThread = null;
                }
            });
            if (pcmFlowThread != null) {
                pcmFlowThread.start();
            }
        }
    }

    /**
     * 以文本的形式持续驱动数字人
     */
    private void flowPlayFlowTxt() {
        // !!! 特别注意如果分段的文字太短则确定效率很低，一定要用文字片段进行驱动。
        synchronized (txtFlowLock) {
            if (txtFlowThread != null) {
                Toast.makeText(mContext, "txt流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (pcmFlowLock) {
            if (pcmFlowThread != null) {
                Toast.makeText(mContext, "pcm流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (txtFlowLock) {
            txtFlowThread = new Thread(() -> {
                String[] segTxtArray = Config.txtLong.split("\n");
                if (segTxtArray != null && segTxtArray.length > 0) {
                    for (int idx = 0; idx < segTxtArray.length; idx++) {
                        PlayTxtResult result = player.speakFlowOnSegTxt(mContext, segTxtArray[idx],
                                SpeakerConf.builder().setPerson(Config.sTtsPerson));
                        Log.i(TAG, "onTtsToPcm,流式txt,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
                        if (!result.isOk()) {
                            FrameDataActivity.this.runOnUiThread(() -> Toast.makeText(mContext,
                                    "文本驱动失败: 'buffer已满'或者'数字人没有进行播放'！",
                                    Toast.LENGTH_SHORT).show());
                        }
                        try {
                            Thread.sleep(10);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Log.i(TAG, "flow thread finish");
                synchronized (txtFlowLock) {
                    txtFlowThread = null;
                }
            });

            if (txtFlowThread != null) {
                txtFlowThread.start();
            }
        }
    }

    /**
     * 停止pcm的流
     */
    private void stopFlowPcm() {
        if (pcmFlowThread != null && pcmFlowThread.isAlive()) {
            pcmFlowThread.interrupt();
        }
        pcmFlowThread = null;
    }

    /**
     * 播放一段pcm
     */
    public void startPlayFile() {
        byte[] pcmBytes = FileUtils.getByte(pcmPath + "input/1_16.pcm");
        byte[] data = PcmNoiseSuppressor.getInstance().audioPreprocessor(pcmBytes);
        player.speakWithPcm(mContext, new int[][]{}, data);
    }

    /**
     * 播放文本
     */
    void startPlayText() {
        PlayTxtResult result = player.speakWithTxt(mContext, Config.shortLong, new int[][]{{1, 1}},
                SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,startPlayText,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
    }

    /**
     * 播放长文本，以插播形式
     */
    void startPlayLongText() {
        PlayTxtResult result = player.speakWithTxt(mContext, Config.txtLong,
                new int[][]{{1, 100}}, SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,startPlayLongText,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
    }

    /**
     * 插播文本
     */
    void playInsertTxt() {
        PlayTxtResult result = player.speakInsertTxt(mContext,
                "你好啊，虽然我不认识您，但是相逢就是有缘，欢迎来到直播间~老铁~",
                SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,playInsertTxt,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
        Toast.makeText(mContext, "插入播报，结果=" + result.isOk(), Toast.LENGTH_SHORT).show();
    }

    /**
     * 插播一条pcm
     */
    void playInserPcm() {
        byte[] pcmBytes = FileUtils.getByte(pcmPath + "input/1.pcm");
        boolean ret = player.speakInsertOnFlowPcm(mContext, pcmBytes);
        Toast.makeText(mContext, "插入播报，结果=" + ret, Toast.LENGTH_SHORT).show();
    }

    /**
     * 打断播报
     */
    void interrupt() {
        player.interrupt();
        if (playMode == PlayMode.FLOW) {
            stopFlowPcm();
        }

        pauseResumeBtn.setText(R.string.play_pause_txt);
    }

    /**
     * 切换数字人形象
     */
    void changeCharacter() {
        if (player.isPlaying()) {
            Toast.makeText(mContext, "正在播报中，不能切换形象！", Toast.LENGTH_SHORT).show();
            return;
        }

        Model newModel = null;
        if (virtualModels != null) {
            for (int idx = 0; idx < virtualModels.size(); idx++) {
                Model modelTraversal = virtualModels.get(idx);
                if (modelTraversal != null) {
                    // 找到当前使用的形象
                    if (useVirtualId == modelTraversal.getVisualize()) {
                        // 最后一个，就使用第一个
                        if (idx == virtualModels.size() - 1) {
                            newModel = virtualModels.get(0);
                        } else {
                            newModel = virtualModels.get(idx + 1);
                        }
                        useVirtualId = newModel.getVisualize();
                        break;
                    }
                }
            }
        } else {
            Log.w(TAG, "changeCharacter: virtualModels is null");
        }

        changeCount++;
        player.changeVirtualModel(newModel, (code, subCode, msg) -> {
            String showMsg = "msgType:" + code + " "
                    + "msgSubType:" + subCode + " "
                    + "msg:" + msg;
            Log.i(TAG, "changeVirtualModel:" + showMsg);
            Toast.makeText(mContext, "changeCount:" + changeCount + " virtualId=" + useVirtualId + "," + showMsg,
                    Toast.LENGTH_SHORT).show();
            System.gc();
        });
    }
}
