package com.baidu.nlp.conversation.demo.settings;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.baidu.nlp.conversation.demo.R;

import java.util.ArrayList;
import java.util.List;

public class SimpleTextAdapter extends RecyclerView.Adapter<SimpleTextAdapter.ViewHolder> {


    private List<SpeakerBean> simpleTextBeans = new ArrayList<>();

    public SimpleTextAdapter(List<SpeakerBean> simpleTextBeans) {
        this.simpleTextBeans = simpleTextBeans;
    }

    public SimpleTextAdapter() {
    }

    @Override
    public int getItemCount() {
        return simpleTextBeans.size();
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.simple_text, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final SpeakerBean bean = simpleTextBeans.get(position);
        holder.tv_item.setText(bean.name);
        holder.itemView.setOnClickListener(view -> {
            listener.onSelected(simpleTextBeans.get(position));
            notifyDataSetChanged();
        });
    }

    public void setDataList(List<SpeakerBean> dataList) {
        simpleTextBeans.clear();
        simpleTextBeans.addAll(dataList);
        notifyDataSetChanged();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tv_item;
        private ImageView iv_status;

        ViewHolder(View itemView) {
            super(itemView);
            tv_item = itemView.findViewById(R.id.tv_item);
            iv_status = itemView.findViewById(R.id.iv_status);
        }
    }

    private OnItemSelectedListener listener;

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.listener = listener;
    }

    public interface OnItemSelectedListener {
        void onSelected(SpeakerBean bean);
    }
}
