package com.baidu.nlp.conversation.demo;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.baidu.aip.vdh.SpeakerConf;
import com.baidu.aip.vdh.VirtualFactory;
import com.baidu.aip.vdh.beans.DisplayMode;
import com.baidu.aip.vdh.beans.Model;
import com.baidu.aip.vdh.beans.VirtualHumanDataBean;
import com.baidu.aip.vdh.core.player.PlayTxtResult;
import com.baidu.aip.vdh.player.Player;
import com.baidu.aip.vdh.utils.FileUtils;
import com.baidu.aip.vdh.utils.PcmNoiseSuppressor;
import com.baidu.nlp.conversation.demo.utils.TimeUtils;

import java.util.ArrayList;
import java.util.List;

public class CheckModelActivity extends AppCompatActivity {
    private static final String TAG = Config.TAG + CheckModelActivity.class.getSimpleName();
    private Context mContext;
    private SurfaceView mSurfaceView;
    private Player player;
    int useVirtualId;
    String figureId;
    String pcmPath = "/sdcard/baidu/aip/face_virtual/";
    private Button pauseResumeBtn = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // 去除标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // 去除状态栏
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        mContext = this;
        setContentView(R.layout.activity_check_model);

        // 显示数字人sdk版本信息
        TextView sdkInfo = findViewById(R.id.sdk_info);
        sdkInfo.setText(com.baidu.aip.vdh.Config.VER + "\n" + com.baidu.aip.vdh.Config.VER_CORE + "\n"
                + VirtualFactory.getEngine().getSdkStatus(CheckModelActivity.this));
        // 显示实时时间
        new TimeUtils(findViewById(R.id.time_text)).start();
        useVirtualId = getIntent().getIntExtra("useVirtualId", 0);
        figureId = getIntent().getStringExtra("figureId");

        initView();
        // 初始化播报
        initPlayer();
    }
    private void initView() {
        // 播放本地pcm文件
        findViewById(R.id.play_pcm_file).setOnClickListener(view -> startPlayFile());
        // 打断播报
        findViewById(R.id.recognize_interrupted).setOnClickListener(v -> interrupt());
        // 播放文本
        findViewById(R.id.play_text).setOnClickListener(v -> startPlayText());

        // 播放长文本
        findViewById(R.id.play_long_txt).setOnClickListener(v -> startPlayLongText());

        // 播报：暂停，继续
        pauseResumeBtn = findViewById(R.id.play_pause_resume);
        pauseResumeBtn.setOnClickListener(v -> {
            if (player.isPlaying()) {
                player.pausePlay();
                pauseResumeBtn.setText(R.string.play_resume_txt);
            } else if (player.isPause()) {
                player.resumePlay();
                pauseResumeBtn.setText(R.string.play_pause_txt);
            }
        });
        findViewById(R.id.release).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ViewGroup parent = (ViewGroup) mSurfaceView.getParent();
                parent.removeView(mSurfaceView);
                mSurfaceView.getHolder().getSurface().release();
                mSurfaceView = null;
            }
        });
    }
    /**
     * 展示数字人以及初始化player
     */
    private void initPlayer() {
        mSurfaceView = findViewById(R.id.surface_view);

        // 1:初始化player
        player = VirtualFactory.getPlayer(mContext);
        // 2:设置是否透明
        boolean isUseTransparent = false;
        if (isUseTransparent) {
            mSurfaceView.getHolder().setFormat(PixelFormat.TRANSLUCENT);
            mSurfaceView.setZOrderOnTop(true);
        } else {
            // 设置背景图（设置背景图与设置透明不能同时开启）
            player.setBackground(BitmapFactory.decodeResource(getResources(), R.color.black));
        }

        // 通过 Surface 展示数字人
        mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback() {
            @Override
            public void surfaceCreated(SurfaceHolder holder) {

            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                player.setDisplay(holder.getSurface(), width, height);
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
                player.release();
                finish();
            }
        });

        // 3: 添加回调
        player.addCallback(new Player.Callback() {
            @Override
            public void onVirtualHumanStart() {
                Log.v(TAG, "onVirtualHumanStart");
                Toast.makeText(mContext, "onVirtualHumanStart", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanFinish() {
                Log.v(TAG, "onVirtualHumanFinish");
                // 播报结束，暂停按钮恢复正常状态
                pauseResumeBtn.setText(R.string.play_pause_txt);
                Toast.makeText(mContext, "onVirtualHumanFinish", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanData(VirtualHumanDataBean frameBean) {

            }


            @Override
            public void onRemainBuffer(int remainBytes, int remainInsertBytes) {
                Log.v(TAG, "onRemainBuffer: remainBytes=" + remainBytes + " remainInsertBytes:" + remainInsertBytes);
            }

            @Override
            public void onPcmVolumeError(int code, String message, float vol) {
                Log.e(TAG, "onPcmVolumeError: volume=" + vol + ", code=" + code + ", message: " + message);
            }

            @Override
            public void onVirtualHumanPause() {
                Log.v(TAG, "onVirtualHumanPause");
                Toast.makeText(mContext, "onVirtualHumanPause", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onError(int code, int subCode, String msg) {
                String showMsg = "error: code:" + code + " subCode:" + subCode + " msg:" + msg;
                Log.e(TAG, showMsg);
//                DialogueActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_SHORT).show());
            }
        });

        if (TextUtils.isEmpty(figureId)){
            boolean isInner = useVirtualId == Config.CONFIG_VISUALIZE;
            if (!isInner){
                String modelPath = isInner
                        ? com.baidu.aip.vdh.Config.INNER_VIRTUAL_MODEL_PATH
                        : player.getVirtualModelPath(false) +useVirtualId;
                String figureValue = FileUtils.getFigureValue(modelPath + "/sdk.info");
                if (TextUtils.isEmpty(figureValue)){
                    useVirtualId = Config.CONFIG_VISUALIZE;
                    Toast.makeText(CheckModelActivity.this, "形象不存在，运行默认形象" + figureId, Toast.LENGTH_SHORT).show();
                }
                figureId = figureValue;

            }

        }
        // 4: 设置数字人模型
        Model model = new Model(useVirtualId, figureId);
        player.setVirtualModel(model, new DisplayMode(), (msgType, msgSubType, msg) -> {
            String showMsg = "msgType:" + msgType + " "
                    + "msgSubType:" + msgSubType + " "
                    + "msg:" + msg;
            Log.i(TAG, "setVirtualModel:" + showMsg);
            Toast.makeText(mContext, "setVirtualModel:" + showMsg, Toast.LENGTH_SHORT).show();
        });
    }

    @Override
    protected void onResume() {
        Log.i(TAG, "onResume");
        player.onResume();
        super.onResume();
    }

    @Override
    protected void onPause() {
        player.onPause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        PcmNoiseSuppressor.getInstance().release();
        Log.i("AipVirtualHuman", "DialogueActivity onDestroy");
    }

    /**
     * 播放一段pcm
     */
    public void startPlayFile() {
        byte[] pcmBytes = FileUtils.getByte(pcmPath + "input/1_16.pcm");
        byte[] data = PcmNoiseSuppressor.getInstance().audioPreprocessor(pcmBytes);
        player.speakWithPcm(mContext, new int[][]{}, data);
    }

    /**
     * 播放文本
     */
    void startPlayText() {
        PlayTxtResult result = player.speakWithTxt(mContext, Config.shortLong, new int[][]{{1, 1}},
                SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,startPlayText,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
    }

    /**
     * 播放长文本，以插播形式
     */
    void startPlayLongText() {
        PlayTxtResult result = player.speakWithTxt(mContext, Config.txtLong,
                new int[][]{{1, 100}}, SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,startPlayLongText,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
    }
    void interrupt() {
        player.interrupt();

        pauseResumeBtn.setText(R.string.play_pause_txt);
    }
}