package com.baidu.nlp.conversation.demo;

import android.app.Activity;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.baidu.aip.vdh.VirtualFactory;
import com.baidu.aip.vdh.beans.DisplayMode;
import com.baidu.aip.vdh.beans.Model;
import com.baidu.aip.vdh.beans.VirtualHumanDataBean;
import com.baidu.aip.vdh.player.Player;
import com.baidu.aip.vdh.utils.FileUtils;
import com.baidu.aip.vdh.utils.PcmNoiseSuppressor;
import com.baidu.nlp.conversation.demo.utils.TimeUtils;
import com.baidu.var.core.virtual.utils.Utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DialogueActivity extends Activity {

    private static final String TAG = Config.TAG + DialogueActivity.class.getSimpleName();

    private int useVirtualId = Config.CONFIG_VISUALIZE;
    private int mSampleRate = 16000;
    private int mChannels = 1;
    private int mBitDepth = 16;
    private int mBytePerMs = (mSampleRate / 1000) * mChannels * (mBitDepth / 8);
    public static final int VAD_FRAME_TIME = 30;
    private int mVadFrameLength = mBytePerMs * VAD_FRAME_TIME / mChannels;
    private int channelConfig = AudioFormat.CHANNEL_IN_MONO;
    private int audioFormat = AudioFormat.ENCODING_PCM_16BIT;
    private String pcmPath = "/sdcard/sound";

    private Context mContext;
    private SurfaceView mSurfaceView;
    private Player player;
    private List<Model> virtualModels = new ArrayList<>();
    private File soundFile;
    private boolean isRecording;
    private int bufferSize;
    private AudioRecord audioRecord;

    private boolean isSavePcm = false;
    File file = new File(Environment.getExternalStorageDirectory(), "pcm");


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // 去除标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // 去除状态栏
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        mContext = this;
        setContentView(R.layout.activity_dialogue);
        // 显示数字人sdk版本信息
        TextView sdkInfo = findViewById(R.id.sdk_info);
        sdkInfo.setText(com.baidu.aip.vdh.Config.VER + "\n" + com.baidu.aip.vdh.Config.VER_CORE + "\n"
                + VirtualFactory.getEngine().getSdkStatus(DialogueActivity.this));
        // 显示实时时间
        new TimeUtils(findViewById(R.id.time_text)).start();
        // 创建audioRecord
        createAudioRecord();

        initView();
        // 初始化播报
        initPlayer();
        // 初始化形象模型
        initModelsData();
    }

    /**
     * 初始化模型数据
     */
    private void initModelsData() {
        // 注：第二个参数figureId为人像资源ID，第三方人像资源必须传非null值，只有内置的默认人像（目前是20）可以传null。该值是调用生成人像的API接口返回的。
        virtualModels.add(new Model(20, null));
    }

    /**
     * 展示数字人以及初始化player
     */
    private void initPlayer() {
        mSurfaceView = findViewById(R.id.surface_view);

        // 1:初始化player
        player = VirtualFactory.getPlayer(mContext);
        // 2:设置是否透明
        boolean isUseTransparent = false;
        if (isUseTransparent) {
            mSurfaceView.getHolder().setFormat(PixelFormat.TRANSLUCENT);
            mSurfaceView.setZOrderOnTop(true);
        } else {
            // 设置背景图（设置背景图与设置透明不能同时开启）
            player.setBackground(BitmapFactory.decodeResource(getResources(), R.mipmap.back));
        }

        // 通过 Surface 展示数字人
        mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback() {
            @Override
            public void surfaceCreated(SurfaceHolder holder) {

            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                player.setDisplay(holder.getSurface(), width, height);
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {

            }
        });

        // 3: 添加回调
        player.addCallback(new Player.Callback() {
            @Override
            public void onVirtualHumanStart() {
                Log.v(TAG, "onVirtualHumanStart");
                Toast.makeText(mContext, "onVirtualHumanStart", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanFinish() {
                Log.v(TAG, "onVirtualHumanFinish");
                // 播报结束，暂停按钮恢复正常状态

                Toast.makeText(mContext, "onVirtualHumanFinish", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanData(VirtualHumanDataBean frameBean) {

            }

            @Override
            public void onRemainBuffer(int remainBytes, int remainInsertBytes) {
                Log.v(TAG, "onRemainBuffer: remainBytes=" + remainBytes + " remainInsertBytes:" + remainInsertBytes);
            }

            @Override
            public void onPcmVolumeError(int code, String message, float vol) {
                Log.e(TAG, "onPcmVolumeError: volume=" + vol + ", code=" + code + ", message: " + message);
            }

            @Override
            public void onVirtualHumanPause() {
                Log.v(TAG, "onVirtualHumanPause");
                Toast.makeText(mContext, "onVirtualHumanPause", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onError(int code, int subCode, String msg) {
                String showMsg = "error: code:" + code + " subCode:" + subCode + " msg:" + msg;
                Log.e(TAG, showMsg);
                DialogueActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_SHORT).show());
            }
        });
        // 4: 设置数字人模型
        Model model = new Model(useVirtualId);
        player.setVirtualModel(model, new DisplayMode(), (msgType, msgSubType, msg) -> {
            String showMsg = "msgType:" + msgType + " "
                    + "msgSubType:" + msgSubType + " "
                    + "msg:" + msg;
            Log.i(TAG, "setVirtualModel:" + showMsg);
            Toast.makeText(mContext, "setVirtualModel:" + showMsg, Toast.LENGTH_SHORT).show();
        });
    }

    @Override
    protected void onResume() {
        Log.i(TAG, "onResume");
        player.onResume();
        super.onResume();
    }

    @Override
    protected void onPause() {
        player.onPause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        // audioRecord 释放
        if (audioRecord != null) {
            audioRecord.release();
        }
        audioRecord = null;
        PcmNoiseSuppressor.getInstance().release();
        System.exit(0);
        Log.i("AipVirtualHuman", "DialogueActivity onDestroy");
    }

    /**
     * 初始化按钮
     */
    private void initView() {
        findViewById(R.id.press_record).setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == MotionEvent.ACTION_DOWN) {
                    if (isRecording) {
                        stopRecord();
                    }
                    startRecord();
                    findViewById(R.id.press_record).setBackgroundResource(R.drawable.btn_press_shape);
                    return true;
                }
                if (motionEvent.getAction() == MotionEvent.ACTION_UP) {
                    findViewById(R.id.press_record).setBackgroundResource(R.drawable.btn_nopress_shape);
                    // 抬起事件
                    stopRecord();
                    // 开始播报音频
                    startPlayFile();
                    return true;
                }
                return false;
            }
        });
        final boolean[] isOnFlowPlay = {false};

        findViewById(R.id.flow_play_btn).setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == MotionEvent.ACTION_DOWN) {
                    if (isRecording) {
                        stopRecord();
                    }
                    startRecord();
                    findViewById(R.id.flow_play_btn).setBackgroundResource(R.drawable.btn_press_shape);
                    return true;
                }
                if (motionEvent.getAction() == MotionEvent.ACTION_UP) {
                    findViewById(R.id.flow_play_btn).setBackgroundResource(R.drawable.btn_nopress_shape);
                    // 抬起事件
                    stopRecord();
                    if (!isOnFlowPlay[0]) {
                        Toast.makeText(mContext, "请开启流式播报", Toast.LENGTH_SHORT).show();
                        return false;
                    }

                    // 开始播报音频
                    startFlowPlayFile();
                    return true;
                }
                return false;
            }
        });
        Button playFlowStartBtn = findViewById(R.id.play_flow_start_btn);
        playFlowStartBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!isOnFlowPlay[0]) {
                    isOnFlowPlay[0] = true;
                    playFlowStartBtn.setText("关闭流式播报");
                    player.speakFlowStart(mContext, true);
                    playFlowStartBtn.setBackgroundResource(R.drawable.btn_press_shape);
                } else {
                    isOnFlowPlay[0] = false;
                    playFlowStartBtn.setText("开启流式播报");
                    playFlowStartBtn.setBackgroundResource(R.drawable.btn_nopress_shape);
                    player.speakFlowFinish(mContext);
                }
            }
        });

        Button realTmeRecord = findViewById(R.id.real_time_record);
        realTmeRecord.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!isRecording) {
                    player.speakFlowStart(mContext, true);
                    realTmeRecord.setText("停止实时音频录制");
                    realTmeRecord.setBackgroundResource(R.drawable.btn_press_shape);

                    if (isRecording) {
                        stopRecord();
                    }
                    startRecord(new AudioRecordCallback() {
                        @Override
                        public void onaudioRecordData(byte[] data) {
//                            byte[] bytes = pcmNoiseSuppressor.audioPreprocessor(data);
                            player.speakFlowOnPcm(mContext, data);
                        }
                    });
                } else {
                    player.speakFlowFinish(mContext);
                    realTmeRecord.setText("开始实时音频录制");
                    realTmeRecord.setBackgroundResource(R.drawable.btn_nopress_shape);
                    stopRecord();
                }
            }
        });
        findViewById(R.id.recognize_interrupted).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                player.interrupt();
            }
        });

        Button isSavePcmBtn = findViewById(R.id.is_save_pcm);
        isSavePcmBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (!isSavePcm) {
                    isSavePcm = true;
                    isSavePcmBtn.setText("关闭音频保存");
                    isSavePcmBtn.setBackgroundResource(R.drawable.btn_press_shape);
                } else {
                    isSavePcm = false;
                    isSavePcmBtn.setText("开启音频保存");
                    isSavePcmBtn.setBackgroundResource(R.drawable.btn_nopress_shape);
                }
            }
        });
    }

    /**
     * 开始播报
     */
    private void startPlayFile() {
        byte[] pcmBytes = FileUtils.getByte(soundFile.getAbsolutePath());
        byte[] pcmData = PcmNoiseSuppressor.getInstance().audioPreprocessor(pcmBytes);
        player.speakWithPcm(mContext, new int[][]{}, pcmData);

        FileUtils.writeBytes(pcmBytes, file.getAbsolutePath() + "/commPCM_.pcm");
        FileUtils.writeBytes(pcmData, file.getAbsolutePath() + "/commPcmNoise_.pcm");
    }

    Thread pcmFlowThread = null;
    Object pcmFlowLock = new Object();

    private void startFlowPlayFile() {
        pcmFlowThread = new Thread(() -> {
            byte[] data = FileUtils.getByte(soundFile.getAbsolutePath());
            int offset = 0;
            List<byte[]> noisePcmData = new ArrayList<>();
            while (true) {
                int count = 32000;
                if (offset + count >= data.length) {
                    count = data.length - offset;
                }

                if (count <= 0) {
                    break;
                }
                byte[] tmp = new byte[count];
                System.arraycopy(data, offset, tmp, 0, count);
                offset += count;
                boolean isOk = player.speakFlowOnPcm(mContext, tmp);
                if (!isOk) {
                    DialogueActivity.this.runOnUiThread(() -> Toast.makeText(mContext,
                            "音频驱动失败: 'buffer已满'或者'数字人没有进行播放'！",
                            Toast.LENGTH_SHORT).show());
                    break;
                }
            }

            if (isSavePcm) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        int noisePcmLength = 0;
                        for (int i = 0; i < noisePcmData.size(); i++) {
                            noisePcmLength += noisePcmData.get(i).length;
                        }
                        byte[] pcmdata = new byte[noisePcmLength];
                        int arrayId = 0;
                        for (int idx = 0; idx < noisePcmData.size(); idx++) {
                            byte[] tempByte = noisePcmData.get(idx);
                            if (null != tempByte) {
                                System.arraycopy(tempByte, 0, pcmdata, arrayId, tempByte.length);
                                arrayId = arrayId + tempByte.length;
                            }
                        }
                        if (!file.exists()) {
                            file.mkdir();
                        }
                        // 保存文件
                        Date date = new Date();
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss");

                        Utils.saveToFile(
                                new File(file.getAbsolutePath()), "flowPCM_.pcm", data);
                        Utils.saveToFile(
                                new File(file.getAbsolutePath()), "flowPcmNoise_.pcm", pcmdata);
                        noisePcmData.clear();
                    }
                }).start();
            }

            Log.i(TAG, "flow thread finish");
            synchronized (pcmFlowLock) {
                pcmFlowThread = null;
            }
        });
        if (pcmFlowThread != null) {
            pcmFlowThread.start();
        }
    }

    /**
     * 创建AudioRecord
     */
    private void createAudioRecord() {
        // 设置采样率
        bufferSize = AudioRecord.getMinBufferSize(mSampleRate, channelConfig, audioFormat);
        audioRecord = new AudioRecord(MediaRecorder.AudioSource.MIC, mSampleRate, channelConfig, audioFormat, bufferSize);

    }

    /**
     * 普通模式开始录制
     */
    private void startRecord() {
        // PCM 文件是否存在， 如果存在则将PCM文件删除
        File path = new File(pcmPath);
        if (!path.exists()) {
            path.mkdir();
        }
        soundFile = new File(path, "raw.pcm");
        if (soundFile.exists()) {
            soundFile.delete();
        }

        if (audioRecord == null) {
            Log.d(TAG, "startRecord= null");
            return;
        }

        isRecording = true;
        final byte[] buffer = new byte[bufferSize];
        // 开始录制
        audioRecord.startRecording();
        new Thread(new Runnable() {
            @Override
            public void run() {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(soundFile);
                    if (fileOutputStream != null) {
                        while (isRecording) {
                            // 循环读取音频流信息
                            int readStatus = audioRecord.read(buffer, 0, bufferSize);
                            Log.d(TAG, "run: readStatus=" + readStatus);
                            // 写入文件
                            fileOutputStream.write(buffer);

                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                    Log.e(TAG, "run: ", e);
                } finally {
                    if (fileOutputStream != null) {
                        try {
                            // 关流
                            fileOutputStream.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }).start();
    }

    /**
     * 实时播报
     *
     * @param audioRecordCallback 实时读取流信息返回
     */
    private void startRecord(AudioRecordCallback audioRecordCallback) {
        if (audioRecord == null) {
            Log.d(TAG, "startRecord= null");
            return;
        }
        // 开始录制
        audioRecord.startRecording();
        isRecording = true;
        new Thread(new Runnable() {
            @Override
            public void run() {
                // 创建 10ms 的byte数组
                byte[] data = new byte[mVadFrameLength];
                while (isRecording) {
                    if (audioRecordCallback != null) {
                        // 读取音频信息
                        audioRecord.read(data, 0, mVadFrameLength);
                        // 将读取出来的音频数据返回
                        audioRecordCallback.onaudioRecordData(data);
                    }
                }
            }
        }).start();

    }

    /**
     * 关闭音频录制
     */
    private void stopRecord() {
        isRecording = false;
        if (audioRecord != null) {
            audioRecord.stop();
        }
    }

    public interface AudioRecordCallback {
        void onaudioRecordData(byte[] data);
    }
}
