package com.baidu.nlp.conversation.demo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;

import com.baidu.aip.vdh.SpeakerConf;
import com.baidu.aip.vdh.VirtualFactory;
import com.baidu.aip.vdh.beans.DisplayMode;
import com.baidu.aip.vdh.beans.Model;
import com.baidu.aip.vdh.beans.VirtualHumanDataBean;
import com.baidu.aip.vdh.core.player.PlayTxtResult;
import com.baidu.aip.vdh.player.Player;
import com.baidu.aip.vdh.utils.FileUtils;
import com.baidu.aip.vdh.utils.PcmNoiseSuppressor;
import com.baidu.aip.vdh.utils.VirtualModelUtil;
import com.baidu.nlp.conversation.demo.utils.TimeUtils;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends Activity {
    public static final String KEY_USEOUTPLAY = MainActivity.class.getName() + "KEY_USEOUTPLAY";
    private static final String TAG = Config.TAG + MainActivity.class.getSimpleName();
    private static final int REQ_SETTINGS = 1000;
    private Context mContext;
    private SurfaceView mSurfaceView;
    int useVirtualId = Config.CONFIG_VISUALIZE;

    // 定制的人像（请查看SDK文档8.1定制人像包替换本地数字人像包），如有需要请联系供应商
    int switchVirtualId = 25;
    private boolean isUseOutPlay = false;
    private Player player;
    private Button checkModelBtn = null;
    private Button modeSwitchBtn = null;
    private Button flowPlayBtn = null;
    private LinearLayout flowPlayLl = null;
    private Button btnUpdateTts = null;
    private LinearLayout commPlayLl = null;
    private Button spUpdateTts = null;
    private Button pauseResumeBtn = null;
    private Button insertPlayBtn = null;
    private EditText inputTtsIdEt;
    private EditText inputTtsKeyEt;
    List<Model> virtualModels = new ArrayList<>();
    int changeCount = 0;
    private int lastTtsPerson;

    private SeekBar sebVolume = null;

    enum PlayMode {
        COMMON,
        FLOW
    }

    PlayMode playMode = PlayMode.COMMON;

    String pcmPath = "/sdcard/baidu/aip/face_virtual/";

    private AlertDialog updateTtsDialog;

    private SharedPreferences mSharedPreferences;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        isUseOutPlay = getIntent().getBooleanExtra(KEY_USEOUTPLAY, false);
        // 去除标题栏
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        // 去除状态栏
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        mContext = this;
        setContentView(R.layout.activity_main);

        mSharedPreferences = getSharedPreferences(Config.PREF_APP_ACCOUNT, MODE_PRIVATE);
        // 初始化player
        initPlayer();

        // 初始化数字人形象数据
        initModelsData();

        setActions();
    }

    private void initPlayer() {
        mSurfaceView = findViewById(R.id.surface_view);

        // 1:初始化player
        player = VirtualFactory.getPlayer(mContext);
        // 2:设置是否透明
        boolean isUseTransparent = false;
        if (isUseTransparent) {
            // TODO 需要实现透明效果，打开下面注释，同时注释掉 mPlayer.setBackground 方法
            mSurfaceView.getHolder().setFormat(PixelFormat.TRANSLUCENT);
            mSurfaceView.setZOrderOnTop(true);
        } else {
            // 设置背景图（设置背景图与设置透明不能同时开启）
            player.setBackground(BitmapFactory.decodeResource(getResources(), R.mipmap.bg_dark_green));
        }

        // 通过 Surface 展示数字人
        mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback() {
            @Override
            public void surfaceCreated(SurfaceHolder holder) {

            }

            @Override
            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                player.setDisplay(holder.getSurface(), width, height);
            }

            @Override
            public void surfaceDestroyed(SurfaceHolder holder) {
                Log.v(TAG, "surfaceDestroyed");
                player.release();
                finish();

            }
        });

        // 通过 SurfaceHolder 展示数字人
        // player.setDisplay(mSurfaceView.getHolder());

        // 3: 添加回调
        player.addCallback(new Player.Callback() {
            @Override
            public void onVirtualHumanStart() {
                Log.v(TAG, "onVirtualHumanStart");
                Toast.makeText(mContext, "onVirtualHumanStart", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanFinish() {
                Log.v(TAG, "onVirtualHumanFinish");
                // 播报结束，暂停按钮恢复正常状态
                pauseResumeBtn.setText(R.string.play_pause_txt);
                Toast.makeText(mContext, "onVirtualHumanFinish", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onVirtualHumanData(VirtualHumanDataBean frameBean) {
                if (isUseOutPlay && null != frameBean.getAudioStreams()) {
                    PcmPlayerUtil.getInstance().start(frameBean.getAudioStreams(), 0, frameBean.getAudioStreams().length);
                }
                Log.v(TAG, "onVirtualHumanData");
            }

            @Override
            public void onRemainBuffer(int remainBytes, int remainInsertBytes) {
                Log.v(TAG, "onRemainBuffer: remainBytes=" + remainBytes + " remainInsertBytes:" + remainInsertBytes);
            }

            @Override
            public void onPcmVolumeError(int code, String message, float vol) {
                Log.e(TAG, "onPcmVolumeError: volume=" + vol + ", code=" + code + ", message: " + message);
            }

            @Override
            public void onVirtualHumanPause() {
                Log.v(TAG, "onVirtualHumanPause");
                Toast.makeText(mContext, "onVirtualHumanPause", Toast.LENGTH_SHORT).show();
            }

            @Override
            public void onError(int code, int subCode, String msg) {
                String showMsg = "error: code:" + code + " subCode:" + subCode + " msg:" + msg;
                Log.e(TAG, showMsg);
                MainActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_SHORT).show());
            }
        });
        // 设置文本转pcm的回调
        player.setPlayTxtCallback(new Player.TxtPlayCallback() {
            @Override
            public void onTtsToPcm(int code, int subCode, String txtSn, String msg) {
                String showMsg = "onTtsToPcm:code=" + code + "，subCode=" + subCode + "，txtSn=" + txtSn + "，msg=" + msg;
                Log.i(TAG, showMsg);
            }
        });

        // 4: 设置数字人模型
//        Model model = new Model(useVirtualId);
        Model model = player.getModel("42154.enc");
        if (isUseOutPlay) {
            model.setCloseAudio(true);
            Toast.makeText(mContext, "外部播放声音", Toast.LENGTH_SHORT).show();
            AudioTrackManager.getInstance().startPlay();
        } else {
            Toast.makeText(mContext, "SDK播放声音", Toast.LENGTH_SHORT).show();
        }
        player.setVirtualModel(model, new DisplayMode(), (code, subCode, msg) -> {
            String showMsg = "msgType:" + code + " "
                    + "msgSubType:" + subCode + " "
                    + "msg:" + msg;
            Log.i(TAG, "setVirtualModel:" + showMsg);
            Toast.makeText(mContext, "setVirtualModel:" + showMsg, Toast.LENGTH_SHORT).show();
        });
    }

    private void setActions() {
        // 播放本地pcm文件
        findViewById(R.id.play_pcm_file).setOnClickListener(view -> startPlayFile());
        // 打断播报
        findViewById(R.id.recognize_interrupted).setOnClickListener(v -> interrupt());
        // 播放文本
        findViewById(R.id.play_text).setOnClickListener(v -> startPlayText());
        // 播放长文本
        findViewById(R.id.play_long_txt).setOnClickListener(v -> startPlayLongText());

        // 开始插播
        insertPlayBtn = findViewById(R.id.play_insert_start_btn);
        insertPlayBtn.setTag(false);
        insertPlayBtn.setOnClickListener(v -> {
            boolean isInsert = (boolean) insertPlayBtn.getTag();
            isInsert = !isInsert;
            if (isInsert) {
                if (player.speakInsertFlowPcmStart(mContext)) {
                    insertPlayBtn.setText(R.string.play_insert_stop_txt);
                    insertPlayBtn.setTag(isInsert);
                    return;
                }
            } else {
                if (player.speakInsertFlowPcmFinish(mContext, true)) {
                    insertPlayBtn.setText(R.string.play_insert_start_txt);
                    insertPlayBtn.setTag(isInsert);
                    return;
                }
            }
            runOnUiThread(() -> Toast.makeText(MainActivity.this, "请在流式模式下切换！", Toast.LENGTH_LONG).show());
        });
        // 插入播报
        findViewById(R.id.play_insert_pcm_btn).setOnClickListener(v -> playInserPcm());
        // 插播pcm
        findViewById(R.id.play_insert_txt_btn).setOnClickListener(v -> playInsertTxt());

        // 切换人物形象
        findViewById(R.id.change_virtual_character).setOnClickListener(v -> changeCharacter());
        findViewById(R.id.release).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ViewGroup parent = (ViewGroup) mSurfaceView.getParent();
                parent.removeView(mSurfaceView);
                mSurfaceView.getHolder().getSurface().release();
                mSurfaceView = null;
            }
        });

        findViewById(R.id.release).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ViewGroup parent = (ViewGroup) mSurfaceView.getParent();
                parent.removeView(mSurfaceView);
                mSurfaceView.getHolder().getSurface().release();
                mSurfaceView = null;
            }
        });

        flowPlayLl = findViewById(R.id.lllayou_left_play_flow);
        commPlayLl = findViewById(R.id.lllayou_left_play_comm);

        btnUpdateTts = findViewById(R.id.btn_update_tts);
        checkModelBtn = findViewById(R.id.check_model_btn);
        // 播报模式
        modeSwitchBtn = findViewById(R.id.play_mode_btn);
        modeSwitchBtn.setTag(PlayMode.COMMON);
        switchPlayMode(PlayMode.COMMON);
        if (modeSwitchBtn.getTag() == PlayMode.COMMON) {
            insertPlayBtn.setVisibility(View.GONE);
        }
        btnUpdateTts.setOnClickListener(v -> {
            showUpdateTtsDialog();
        });

        checkModelBtn.setOnClickListener(v -> {
            Log.i(TAG, "checkModelBtn onClick");

            // 请注意：这里Model的两个参数是定制的人像（请查看SDK文档8.1定制人像包替换本地数字人像包），如有需要请联系供应商
            Model model = new Model(switchVirtualId, "650565da67f58cf527ff855c");
            VirtualModelUtil.checkModel(model, (figureId, code, subCode, msg) -> {
                String compositeMsg = "[checkModel]: figureId:" + figureId
                        + " msgType:" + code + " msgSubType:" + subCode + " msg:" + msg;
                Log.i(TAG, compositeMsg);
                runOnUiThread(() -> Toast.makeText(MainActivity.this, compositeMsg, Toast.LENGTH_LONG).show());
            });
        });

        modeSwitchBtn.setOnClickListener(v -> {
            if (player.isPlaying()) {
                Toast.makeText(mContext, "正在播报中，不能切换播报模式~", Toast.LENGTH_SHORT).show();
                return;
            }
            if (player.isPause()) {
                Toast.makeText(mContext, "处于暂停状态，不能切换播报模式~", Toast.LENGTH_SHORT).show();
                return;
            }
            PlayMode mode = (PlayMode) modeSwitchBtn.getTag();
            if (mode == PlayMode.COMMON) {
                mode = PlayMode.FLOW;
                insertPlayBtn.setVisibility(View.VISIBLE);
            } else if (mode == PlayMode.FLOW) {
                mode = PlayMode.COMMON;
                insertPlayBtn.setVisibility(View.GONE);
            }
            switchPlayMode(mode);
            modeSwitchBtn.setTag(mode);
        });

        // 播报：暂停，继续
        pauseResumeBtn = findViewById(R.id.play_pause_resume);
        pauseResumeBtn.setOnClickListener(v -> {
            if (player.isPlaying()) {
                player.pausePlay();
                pauseResumeBtn.setText(R.string.play_resume_txt);
            } else if (player.isPause()) {
                player.resumePlay();
                pauseResumeBtn.setText(R.string.play_pause_txt);
            }
        });

        // 流式播放
        flowPlayBtn = findViewById(R.id.play_flow_start_btn);
        flowPlayBtn.setOnClickListener(v -> flowPlayStartStop()); // 流式开始&结束
        findViewById(R.id.play_flow_pcm_btn).setOnClickListener(v -> flowPlayFlowPcm()); // 以pcm的流持续驱动
        findViewById(R.id.play_flow_txt_btn).setOnClickListener(v -> flowPlayFlowTxt()); // 以txt的流持续驱动

        // 显示数字人sdk版本信息
        TextView sdkInfo = findViewById(R.id.sdk_info);
        sdkInfo.setText(com.baidu.aip.vdh.Config.VER + "\n" + com.baidu.aip.vdh.Config.VER_CORE + "\n"
                + VirtualFactory.getEngine().getSdkStatus(MainActivity.this));

        sebVolume = findViewById(R.id.seekBar_volume);
        sebVolume.setMax(10);
        sebVolume.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                if (player != null) {
                    player.setPcmVolume(i);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        // 显示实时时间
        new TimeUtils(findViewById(R.id.time_text)).start();
    }

    private void showUpdateTtsDialog() {
        if (updateTtsDialog == null) {
            View view = LayoutInflater.from(MainActivity.this).inflate(R.layout.dialog_update_tts, null);
            updateTtsDialog = new AlertDialog.Builder(MainActivity.this)
                    .setView(view)
                    .show();

            inputTtsIdEt = view.findViewById(R.id.sp_input_tts_id_et);
            inputTtsKeyEt = view.findViewById(R.id.sp_input_tts_key_et);
            if (TextUtils.isEmpty(Config.sTtsId)) {
                Config.sTtsId = mSharedPreferences.getString(Config.KEY_TTS_ID, "");
            }
            if (TextUtils.isEmpty(Config.sTtsKey)) {
                Config.sTtsKey = mSharedPreferences.getString(Config.KEY_TTS_KEY, "");
            }
            inputTtsIdEt.setText(Config.sTtsId);
            inputTtsKeyEt.setText(Config.sTtsKey);
            inputTtsIdEt.setSelection(inputTtsIdEt.getText().length());
            inputTtsKeyEt.setSelection(inputTtsKeyEt.getText().length());
            spUpdateTts = view.findViewById(R.id.sp_update_tts);
            spUpdateTts.setOnClickListener(v -> {
                sdkUpdateTts();
            });
        } else {
            if (TextUtils.isEmpty(Config.sTtsId)) {
                Config.sTtsId = mSharedPreferences.getString(Config.KEY_TTS_ID, "");
            }
            if (TextUtils.isEmpty(Config.sTtsKey)) {
                Config.sTtsKey = mSharedPreferences.getString(Config.KEY_TTS_KEY, "");
            }
            inputTtsIdEt.setText(Config.sTtsId);
            inputTtsKeyEt.setText(Config.sTtsKey);
            inputTtsIdEt.setSelection(inputTtsIdEt.getText().length());
            inputTtsKeyEt.setSelection(inputTtsKeyEt.getText().length());
            updateTtsDialog.show();
        }
    }

    private void hideUpdateTtsDialog() {
        updateTtsDialog.hide();
    }

    private void sdkUpdateTts() {
        String ttsId = inputTtsIdEt.getText().toString().trim();
        String ttsKey = inputTtsKeyEt.getText().toString().trim();
        if (TextUtils.isEmpty(ttsId)) {
            Toast.makeText(mContext, "请输入有效的: ttsId", Toast.LENGTH_LONG).show();
            return;
        }
        if (TextUtils.isEmpty(ttsKey)) {
            Toast.makeText(mContext, "请输入有效的: ttsKey", Toast.LENGTH_LONG).show();
            return;
        }
        VirtualFactory.getEngine().updateTtsParam(ttsId, ttsKey);
        if (!TextUtils.isEmpty(ttsId)) {
            mSharedPreferences.edit().putString(Config.KEY_TTS_ID, ttsId).commit();
        }
        if (!TextUtils.isEmpty(ttsKey)) {
            mSharedPreferences.edit().putString(Config.KEY_TTS_KEY, ttsKey).commit();
        }
        Config.sTtsId = ttsId;
        Config.sTtsKey = ttsKey;
        inputTtsIdEt.getText().clear();
        inputTtsKeyEt.getText().clear();
        hideUpdateTtsDialog();
    }

    /**
     * 初始化模型数据
     */
    private void initModelsData() {
        // 注：第二个参数figureId为人像资源ID，第三方人像资源必须传非null值，只有内置的默认人像（目前是10001）可以传null。该值是调用生成人像的API接口返回的。
        virtualModels.add(new Model(useVirtualId, null));

        // 这里是定制的人像（请查看SDK文档8.1定制人像包替换本地数字人像包），如有需要请联系供应商
        virtualModels.add(player.getModel("42154.enc"));
    }

    /**
     * 切换播报模式
     *
     * @param mode
     */
    private void switchPlayMode(PlayMode mode) {
        if (mode == PlayMode.FLOW) {
            flowPlayLl.setVisibility(View.VISIBLE);
            commPlayLl.setVisibility(View.GONE);
            modeSwitchBtn.setText("模式：流式播放");
        } else if (mode == PlayMode.COMMON) {
            flowPlayLl.setVisibility(View.GONE);
            commPlayLl.setVisibility(View.VISIBLE);
            modeSwitchBtn.setText("模式：普通播放");
        }
        playMode = mode;
    }

    @Override
    protected void onResume() {
        Log.i(TAG, "onResume");
        player.onResume();
        super.onResume();
    }

    @Override
    protected void onPause() {
        player.onPause();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (isUseOutPlay) {
            PcmPlayerUtil.getInstance().release();
        }
        PcmNoiseSuppressor.getInstance().release();
//        System.exit(0);
        Log.i("AipVirtualHuman", "MainActivity onDestroy");
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.i(TAG, "onActivityResult, requestCode:" + requestCode + ", resultCode:" + resultCode);
        switch (requestCode) {
            case REQ_SETTINGS:
                if (resultCode == RESULT_CANCELED) {
                    boolean isTtsPersonChanged = lastTtsPerson != Config.sTtsPerson;
                    Log.i(TAG, "onActivityResult, isTtsPersonChanged:" + isTtsPersonChanged);
                    if (isTtsPersonChanged) {
                        Toast.makeText(this, "修改音色库只对下次的文本驱动生效", Toast.LENGTH_LONG).show();
                    }
                }
                break;
            default:
                break;
        }
    }

    Thread pcmFlowThread = null;
    Object pcmFlowLock = new Object();

    Thread txtFlowThread = null;
    Object txtFlowLock = new Object();

    /**
     * 流式播报开始
     */
    private void flowPlayStartStop() {
        if (!player.isPlaying() && !player.isPause()) {
            // 流式播报的情况下，播放中，和暂停，都属于在播报
            player.speakFlowStart(mContext, true);
            flowPlayBtn.setText(R.string.play_flow_finish);
            Toast.makeText(mContext, "流式播报开始!", Toast.LENGTH_SHORT).show();
        } else {
            player.speakFlowFinish(mContext);
            flowPlayBtn.setText(R.string.play_flow_start);
            Toast.makeText(mContext, "流式播报结束！", Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 以pcm持续驱动数字人
     */
    private void flowPlayFlowPcm() {
        synchronized (pcmFlowLock) {
            if (pcmFlowThread != null) {
                Toast.makeText(mContext, "pcm流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (txtFlowLock) {
            if (txtFlowThread != null) {
                Toast.makeText(mContext, "txt流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (pcmFlowLock) {
            pcmFlowThread = new Thread(() -> {
                byte[] data = FileUtils.getByte(pcmPath + "input/1_16.pcm");
                int offset = 0;
                while (true) {
                    int count = 32000;
                    if (offset + count >= data.length) {
                        count = data.length - offset;
                    }

                    if (count <= 0) {
                        break;
                    }
                    Log.i(TAG, "count:" + count);

                    byte[] tmp = new byte[count];
                    System.arraycopy(data, offset, tmp, 0, count);
                    offset += count;
                    boolean isOk = player.speakFlowOnPcm(mContext, tmp);
                    if (!isOk) {
                        MainActivity.this.runOnUiThread(() -> Toast.makeText(mContext,
                                "音频驱动失败: 'buffer已满'或者'数字人没有进行播放'！",
                                Toast.LENGTH_SHORT).show());
                        break;
                    }
                }

                Log.i(TAG, "flow thread finish");
                synchronized (pcmFlowLock) {
                    pcmFlowThread = null;
                }
            });
            if (pcmFlowThread != null) {
                pcmFlowThread.start();
            }
        }
    }

    /**
     * 以文本的形式持续驱动数字人
     */
    private void flowPlayFlowTxt() {
        // !!! 特别注意如果分段的文字太短则确定效率很低，一定要用文字片段进行驱动。
        synchronized (txtFlowLock) {
            if (txtFlowThread != null) {
                Toast.makeText(mContext, "txt流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (pcmFlowLock) {
            if (pcmFlowThread != null) {
                Toast.makeText(mContext, "pcm流式驱动中!", Toast.LENGTH_SHORT).show();
                return;
            }
        }

        synchronized (txtFlowLock) {
            txtFlowThread = new Thread(() -> {
                String[] segTxtArray = Config.txtLong.split("\n");
                if (segTxtArray != null && segTxtArray.length > 0) {
                    for (int idx = 0; idx < segTxtArray.length; idx++) {
                        PlayTxtResult result = player.speakFlowOnSegTxt(mContext, segTxtArray[idx],
                                SpeakerConf.builder().setPerson(Config.sTtsPerson));
                        Log.i(TAG, "onTtsToPcm,流式txt,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
                        if (!result.isOk()) {
                            MainActivity.this.runOnUiThread(() -> Toast.makeText(mContext,
                                    "文本驱动失败: 'buffer已满'或者'数字人没有进行播放'！",
                                    Toast.LENGTH_SHORT).show());
                        }
                        try {
                            Thread.sleep(10);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Log.i(TAG, "flow thread finish");
                synchronized (txtFlowLock) {
                    txtFlowThread = null;
                }
            });

            if (txtFlowThread != null) {
                txtFlowThread.start();
            }
        }
    }

    /**
     * 停止pcm的流
     */
    private void stopFlowPcm() {
        if (pcmFlowThread != null && pcmFlowThread.isAlive()) {
            pcmFlowThread.interrupt();
        }
        pcmFlowThread = null;
    }

    /**
     * 播放一段pcm
     */
    public void startPlayFile() {
        byte[] pcmBytes = FileUtils.getByte(pcmPath + "input/1_16.pcm");
        byte[] data = PcmNoiseSuppressor.getInstance().audioPreprocessor(pcmBytes);
        player.speakWithPcm(mContext, new int[][]{}, data);
    }

    /**
     * 播放文本
     */
    void startPlayText() {
        PlayTxtResult result = player.speakWithTxt(mContext, Config.shortLong, new int[][]{{0, 0}},
                SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,startPlayText,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
    }

    /**
     * 播放长文本，以插播形式
     */
    void startPlayLongText() {
        PlayTxtResult result = player.speakWithTxt(mContext, Config.txtLong,
                new int[][]{{0, 0}}, SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,startPlayLongText,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
    }

    /**
     * 插播文本
     */
    void playInsertTxt() {
        PlayTxtResult result = player.speakInsertTxt(mContext,
                "你好啊，虽然我不认识您，但是相逢就是有缘，欢迎来到直播间~老铁~",
                SpeakerConf.builder().setPerson(Config.sTtsPerson));
        Log.i(TAG, "onTtsToPcm,playInsertTxt,isok=" + result.isOk() + ",result.txtSn=" + result.getTxtSn());
        Toast.makeText(mContext, "插入播报，结果=" + result.isOk(), Toast.LENGTH_SHORT).show();
    }

    /**
     * 插播一条pcm
     */
    void playInserPcm() {
        byte[] pcmBytes = FileUtils.getByte(pcmPath + "input/1.pcm");
        boolean ret = player.speakInsertOnFlowPcm(mContext, pcmBytes);
        Toast.makeText(mContext, "插入播报，结果=" + ret, Toast.LENGTH_SHORT).show();
    }

    /**
     * 打断播报
     */
    void interrupt() {
        player.interrupt();
        if (playMode == PlayMode.FLOW) {
            stopFlowPcm();
        }

        pauseResumeBtn.setText(R.string.play_pause_txt);
    }

    /**
     * 切换数字人形象
     */
    void changeCharacter() {
        if (player.isPlaying()) {
            Toast.makeText(mContext, "正在播报中，不能切换形象！", Toast.LENGTH_SHORT).show();
            return;
        }

        Model newModel = null;
        if (virtualModels != null) {
            int currentIndex = changeCount % virtualModels.size();
            newModel = virtualModels.get(currentIndex);
        } else {
            Log.w(TAG, "changeCharacter: virtualModels is null");
        }

        changeCount++;
        player.changeVirtualModel(newModel, (code, subCode, msg) -> {
            String showMsg = "msgType:" + code + " "
                    + "msgSubType:" + subCode + " "
                    + "msg:" + msg;
            Log.i(TAG, "changeVirtualModel:" + showMsg);
            Toast.makeText(mContext, "changeCount:" + changeCount + " virtualId=" + useVirtualId + "," + showMsg,
                    Toast.LENGTH_SHORT).show();
            System.gc();
        });
    }
}
