package com.baidu.nlp.conversation.demo;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.baidu.aip.vdh.VirtualAuth;
import com.baidu.aip.vdh.VirtualCodes;
import com.baidu.aip.vdh.VirtualEnvType;
import com.baidu.aip.vdh.VirtualFactory;
import com.baidu.aip.vdh.VirtualInitParam;
import com.baidu.aip.vdh.VirtualLogType;
import com.baidu.aip.vdh.beans.Model;
import com.baidu.aip.vdh.engine.EnginStateManager;
import com.baidu.aip.vdh.utils.LoadVirtualModel;

public class SplashActivity extends BaseActivity implements BaseActivity.PermissionsListener {
    private static final String TAG = Config.TAG + SplashActivity.class.getSimpleName();
    private static final String KEY_APP_KEY = "app_key";
    private static final String KEY_SECERET_KEY = "seceret_key";

    private Context mContext;
    final VirtualAuth vhAuth = new VirtualAuth();

    private EditText inputAppkeyEt;
    private EditText inputSeceretEt;
    private EditText inputTtsIdEt;
    private EditText inputTtsKeyEt;

    private EditText inputActCodeEt;

    private Button spSetPlayWayBt;

    private SharedPreferences mSharedPreferences;
    private SharedPreferences mSettingsSharedPreferences;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.setListener(this);
        this.mContext = this;
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);
        mSettingsSharedPreferences = getSharedPreferences(SettingsActivity.PREF_SETTINGS, MODE_PRIVATE);
        Config.sTtsPerson = mSettingsSharedPreferences.getInt(SettingsActivity.KEY_TTS_PERSON, Config.sTtsPerson);
        // 确定有权限后，才能使用
        enableButtons(false);

        // 授权码
        findViewById(R.id.sp_view_sdk_init).setOnClickListener(v -> initSdk());
        findViewById(R.id.sp_bt_project_auth_test).setOnClickListener(v -> getProjectAuthInfo());

        inputAppkeyEt = findViewById(R.id.sp_input_appkey_et);
        mSharedPreferences = getSharedPreferences(Config.PREF_APP_ACCOUNT, MODE_PRIVATE);
        if (TextUtils.isEmpty(Config.sAppKey)) {
            Config.sAppKey = mSharedPreferences.getString(KEY_APP_KEY, "");
        }
        inputAppkeyEt.setText(Config.sAppKey);
        inputSeceretEt = findViewById(R.id.sp_input_seceret_et);
        if (TextUtils.isEmpty(Config.sSeceretKey)) {
            Config.sSeceretKey = mSharedPreferences.getString(KEY_SECERET_KEY, "");
        }
        inputSeceretEt.setText(Config.sSeceretKey);

        inputTtsIdEt = findViewById(R.id.sp_input_tts_id_et);
        if (TextUtils.isEmpty(Config.sTtsId)) {
            Config.sTtsId = mSharedPreferences.getString(Config.KEY_TTS_ID, "");
        }
        inputTtsIdEt.setText(Config.sTtsId);
        inputTtsKeyEt = findViewById(R.id.sp_input_tts_key_et);
        if (TextUtils.isEmpty(Config.sTtsKey)) {
            Config.sTtsKey = mSharedPreferences.getString(Config.KEY_TTS_KEY, "");
        }
        inputTtsKeyEt.setText(Config.sTtsKey);

        findViewById(R.id.sp_view_sdk_auth).setOnClickListener(v -> sdkAuthStateView());
        findViewById(R.id.sp_start_sdk_auth_surface).setOnClickListener(v -> sdkAuthinit());
        findViewById(R.id.sp_start_sdk_auth_image).setOnClickListener(v -> sdkAuthinitImage());
        findViewById(R.id.sp_auth_change_device).setOnClickListener(v -> sdkChangeAuthDevice());
        findViewById(R.id.sp_activate_btn).setOnClickListener(v -> sdkActivate());
        findViewById(R.id.sp_check_model_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                modelCheckinit();
            }
        });


        spSetPlayWayBt = findViewById(R.id.sp_set_play_way_bt);
        // 默认sdk播放声音
        spSetPlayWayBt.setTag(false);
        spSetPlayWayBt.setOnClickListener(v -> {
            if (spSetPlayWayBt.getTag() == null) {
                // tag == true，使用外部播放器播放
                spSetPlayWayBt.setTag(true);
            } else {
                boolean isUseOutPlay = (boolean) spSetPlayWayBt.getTag();
                spSetPlayWayBt.setTag(!isUseOutPlay);
            }

            if ((boolean) spSetPlayWayBt.getTag()) {
                spSetPlayWayBt.setText("外部播放声音");
            } else {
                spSetPlayWayBt.setText("SDK播放声音");
            }

            Toast.makeText(mContext, spSetPlayWayBt.getText(), Toast.LENGTH_LONG).show();
        });

        inputActCodeEt = findViewById(R.id.sp_input_activate_code_et);
        inputActCodeEt.setText(Config.sTimeKey);
        // 设置log级别
        VirtualFactory.getEngine().setLog(VirtualLogType.VERBOSE);
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        enableButtons(true);

        if (TextUtils.isEmpty(Config.sTtsId)) {
            Config.sTtsId = mSharedPreferences.getString(Config.KEY_TTS_ID, "");
        }
        if (TextUtils.isEmpty(Config.sTtsKey)) {
            Config.sTtsKey = mSharedPreferences.getString(Config.KEY_TTS_KEY, "");
        }
        inputTtsIdEt.setText(Config.sTtsId);
        inputTtsKeyEt.setText(Config.sTtsKey);
        inputTtsIdEt.setSelection(inputTtsIdEt.getText().length());
        inputTtsKeyEt.setSelection(inputTtsKeyEt.getText().length());
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    /**
     * 6.0 权限获取成功之后回调，初始化虚拟人SDK 功能和人脸识别SDK 功能
     */
    @Override
    public void init() {
        // 权限获取成功后，显示可以操作的界面
    }

    private void enableButtons(boolean isEnable) {
        findViewById(R.id.sp_view_sdk_auth).setEnabled(isEnable);
        findViewById(R.id.sp_start_sdk_auth_surface).setEnabled(isEnable);
        findViewById(R.id.sp_start_sdk_auth_image).setEnabled(isEnable);
        findViewById(R.id.sp_auth_change_device).setEnabled(isEnable);
        findViewById(R.id.sp_activate_btn).setEnabled(isEnable);
        findViewById(R.id.sp_set_play_way_bt).setEnabled(isEnable);
    }


    /**
     * 获取项目授权信息
     */
    private void getProjectAuthInfo() {
        String appKey = inputAppkeyEt.getText().toString();
        String seceretKey = inputSeceretEt.getText().toString();
        String ttsId = inputTtsIdEt.getText().toString();
        String ttsKey = inputTtsKeyEt.getText().toString();
        if (TextUtils.isEmpty(appKey)) {
            Toast.makeText(mContext, "请输入有效的: appKey", Toast.LENGTH_LONG).show();
            return;
        }
        if (TextUtils.isEmpty(seceretKey)) {
            Toast.makeText(mContext, "请输入有效的: seceretKey", Toast.LENGTH_LONG).show();
            return;
        }
        if (!TextUtils.isEmpty(ttsId) && TextUtils.isEmpty(ttsKey)
                || !TextUtils.isEmpty(ttsKey) && TextUtils.isEmpty(ttsId)) {
            Toast.makeText(mContext, "文字输入驱动请输入有效的: ttsId和ttsKey，如使用语音驱动，请删掉ttsId和ttsKey", Toast.LENGTH_LONG).show();
            return;
        }

        VirtualFactory.getEngine().setEnv(mContext, VirtualEnvType.Release);

        if (!TextUtils.isEmpty(EnginStateManager.instance().getAppKey())
                & !TextUtils.isEmpty(EnginStateManager.instance().getSeceretKey())) {
            appKey = EnginStateManager.instance().getAppKey();
            seceretKey = EnginStateManager.instance().getSeceretKey();
        }
        VirtualInitParam virtualInitParam = new VirtualInitParam();
        virtualInitParam.appKey = appKey;
        virtualInitParam.seceretKey = seceretKey;
        virtualInitParam.ttsId = ttsId;
        virtualInitParam.ttsKey = ttsKey;
        VirtualFactory.getEngine().initProjectAuth(SplashActivity.this, vhAuth, virtualInitParam, new VirtualAuth.AuthCallBack() {
            @Override
            public void onMessage(int code, int subCode, String msg) {
                String logMsg = "getProjectAuthInfo,code=" + code + ",subCode=" + subCode + ",msg=" + msg;
                Log.i(TAG, logMsg);
                enableButtons(true);
            }
        });
    }

    /**
     * 初始化sdk
     */
    private void initSdk() {
        String appKey = inputAppkeyEt.getText().toString();
        String seceretKey = inputSeceretEt.getText().toString();
        String ttsId = inputTtsIdEt.getText().toString();
        String ttsKey = inputTtsKeyEt.getText().toString();
        if (TextUtils.isEmpty(appKey)) {
            Toast.makeText(mContext, "请输入有效的: appKey", Toast.LENGTH_LONG).show();
            return;
        }
        if (TextUtils.isEmpty(seceretKey)) {
            Toast.makeText(mContext, "请输入有效的: seceretKey", Toast.LENGTH_LONG).show();
            return;
        }
        if (!TextUtils.isEmpty(ttsId) && TextUtils.isEmpty(ttsKey)
                || !TextUtils.isEmpty(ttsKey) && TextUtils.isEmpty(ttsId)) {
            Toast.makeText(mContext, "文字输入驱动请输入有效的: ttsId和ttsKey，如使用语音驱动，请删掉ttsId和ttsKey", Toast.LENGTH_LONG).show();
            return;
        }

        VirtualFactory.getEngine().setEnv(mContext, VirtualEnvType.Release);

        if (!TextUtils.isEmpty(EnginStateManager.instance().getAppKey())
                & !TextUtils.isEmpty(EnginStateManager.instance().getSeceretKey())) {
            appKey = EnginStateManager.instance().getAppKey();
            seceretKey = EnginStateManager.instance().getSeceretKey();
        }

        VirtualInitParam virtualInitParam = new VirtualInitParam();
        virtualInitParam.appKey = appKey;
        virtualInitParam.seceretKey = seceretKey;
        virtualInitParam.ttsId = ttsId;
        virtualInitParam.ttsKey = ttsKey;
        int ret = VirtualFactory.getEngine().init(this, virtualInitParam);

        boolean isOk = ret == VirtualCodes.VirtualInitType.INIT_SUCCESS.getValue();
        Toast.makeText(mContext, "init: " + isOk + "（" + ret + "）", Toast.LENGTH_LONG).show();
        if (isOk) {
            findViewById(R.id.sp_view_sdk_init).setEnabled(false);
            inputAppkeyEt.setEnabled(false);
            inputSeceretEt.setEnabled(false);
            enableButtons(true);
        }

        // 自定义模型存储位置
        Log.i(TAG, "自定义模型位置：" + VirtualFactory.getEngine().getThirdVirtualModelPath());
    }

    /**
     * 查看sdk的授权状态
     */
    private void sdkAuthStateView() {
        enableButtons(false);
        // 获取激活状态
        vhAuth.getOauthState(mContext, (code, subCode, activeTime, expirationTime, msg) -> {
            enableButtons(true);
            String showMsg = "msgType:" + code + " "
                    + "msgSubType:" + subCode + " "
                    + "activeTime:" + activeTime + " "
                    + "expirationTime:" + expirationTime + " "
                    + "msg:" + msg;
            Log.i(TAG, "onAuthStatus:" + showMsg);
            SplashActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_LONG).show());
        });
    }

    /**
     * 设备使用时长激活/延期
     */
    private void sdkActivate() {
        String inputCode = inputActCodeEt.getText().toString();
        if (TextUtils.isEmpty(inputCode)) {
            Toast.makeText(mContext, "请输入有效的授权码", Toast.LENGTH_LONG).show();
            return;
        }
        enableButtons(false);
        vhAuth.renewExpirationDate(mContext, inputCode, (code, subCode, expirationTime, msg) -> {
            enableButtons(true);
            String showMsg = "msgType:" + code + " "
                    + "msgSubType:" + subCode + " "
                    + "expirationTime:" + expirationTime + " "
                    + "msg:" + msg;
            Log.i(TAG, "renewExpirationDate:" + showMsg);
            SplashActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_LONG).show());
        });
    }

    private void sdkAuthinit() {
        // 解决多次点击打开多个页面或者页面无响应问题
        enableButtons(false);
        // 进行授权
        vhAuth.initLicenseBatch(mContext,
                (code, subCode, msg) -> {
                    if (code == 0) {
                        VirtualFactory.getEngine().loadModel(this, "42154.enc", "i-qicsmyfe2vfkp", new LoadVirtualModel.LoadVirtualModelCallback() {
                            @Override
                            public void onSuccess(Model model) {
                                SplashActivity.this.runOnUiThread(() -> {
                                    saveAppAccount();
                                    startActivity();
                                });
                            }

                            @Override
                            public void onError(int code, String msg) {

                            }
                        });
                    } else {
                        enableButtons(true);
                        String showMsg = "msgType:" + code + " msgSubType:" + subCode + " msg:" + msg;
                        Log.e(TAG, showMsg);
                        SplashActivity.this.runOnUiThread(() -> Toast.makeText(SplashActivity.this, showMsg,
                                Toast.LENGTH_LONG).show());
                    }
                });
    }

    private void sdkAuthinitImage() {
        // 解决多次点击打开多个页面或者页面无响应问题
        enableButtons(false);
        // 进行授权
        vhAuth.initLicenseBatch(mContext,
                (code, subCode, msg) -> {
                    if (code == 0) {
                        VirtualFactory.getEngine().loadModel(this, "42154.enc", "i-qicsmyfe2vfkp", new LoadVirtualModel.LoadVirtualModelCallback() {
                            @Override
                            public void onSuccess(Model model) {
                                SplashActivity.this.runOnUiThread(() -> {
                                    saveAppAccount();
                                    startActivity();
                                });
                            }

                            @Override
                            public void onError(int code, String msg) {

                            }
                        });
                    } else {
                        enableButtons(true);
                        String showMsg = "msgType:" + code + " msgSubType:" + subCode + " msg:" + msg;
                        Log.e(TAG, showMsg);
                        SplashActivity.this.runOnUiThread(() -> Toast.makeText(SplashActivity.this, showMsg,
                                Toast.LENGTH_LONG).show());
                    }
                });
    }

    /**
     * 保存应用账号信息到SharedPreferences
     */
    private void saveAppAccount() {
        String appKey = inputAppkeyEt.getText().toString().trim();
        String seceretKey = inputSeceretEt.getText().toString().trim();
        String ttsId = inputTtsIdEt.getText().toString().trim();
        String ttsKey = inputTtsKeyEt.getText().toString().trim();
        Log.i(TAG, "saveAppAccount, appKey:" + appKey + ", seceretKey:" + seceretKey
                + ", ttsId:" + ttsId + ", ttsKey:" + ttsKey);

        if (!TextUtils.isEmpty(appKey)) {
            mSharedPreferences.edit().putString(KEY_APP_KEY, appKey).commit();
        }
        if (!TextUtils.isEmpty(seceretKey)) {
            mSharedPreferences.edit().putString(KEY_SECERET_KEY, seceretKey).commit();
        }
        if (!TextUtils.isEmpty(ttsId)) {
            mSharedPreferences.edit().putString(Config.KEY_TTS_ID, ttsId).commit();
            Config.sTtsId = ttsId;
        } else {
            mSharedPreferences.edit().putString(Config.KEY_TTS_ID, "").commit();
            Config.sTtsId = "";
        }
        if (!TextUtils.isEmpty(ttsKey)) {
            mSharedPreferences.edit().putString(Config.KEY_TTS_KEY, ttsKey).commit();
            Config.sTtsKey = ttsKey;
        } else {
            mSharedPreferences.edit().putString(Config.KEY_TTS_KEY, "").commit();
            Config.sTtsKey = "";
        }
    }

    private void startActivity() {
        new Handler(
                msg -> {
                    Intent intent = new Intent(mContext, MainActivity.class);
                    intent.putExtra(MainActivity.KEY_USEOUTPLAY, spSetPlayWayBt.getTag() == null ?
                            false : (boolean) spSetPlayWayBt.getTag());
                    startActivity(intent);
//                    finish();
                    return false;
                })
                .sendEmptyMessageDelayed(0, 500);
    }

    private void startActivityImage() {
        new Handler(
                msg -> {
                    Intent intent = new Intent(mContext, FrameDataActivity.class);
                    intent.putExtra(FrameDataActivity.KEY_USEOUTPLAY, spSetPlayWayBt.getTag() == null ?
                            false : (boolean) spSetPlayWayBt.getTag());
                    startActivity(intent);
                    return false;
                })
                .sendEmptyMessageDelayed(0, 1000);
    }

    /**
     * 将initsdk中的授权码换绑到其他设备上
     */
    private void sdkChangeAuthDevice() {
        vhAuth.changeDeviceBind(mContext, (code, subCode, msg) -> {
            String showMsg = "msgType:" + code + " "
                    + "msgSubType:" + subCode + " "
                    + "msg:" + msg;
            Log.i(TAG, "onAuthStatus:" + showMsg);
            SplashActivity.this.runOnUiThread(() -> Toast.makeText(mContext, showMsg, Toast.LENGTH_LONG).show());
        });
    }

    private void modelCheckinit() {
        // 解决多次点击打开多个页面或者页面无响应问题
        enableButtons(false);
        // 进行授权
        vhAuth.initLicenseBatch(mContext,
                (code, subCode, msg) -> {
                    if (code == 0) {
                        SplashActivity.this.runOnUiThread(() -> {
                            saveAppAccount();
                            showDialog();
                        });
                    } else {
                        enableButtons(true);
                        String showMsg = "msgType:" + code + " msgSubType:" + subCode + " msg:" + msg;
                        Log.e(TAG, showMsg);
                        SplashActivity.this.runOnUiThread(() -> Toast.makeText(SplashActivity.this, showMsg,
                                Toast.LENGTH_LONG).show());
                    }
                });
    }
    private void showDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        LayoutInflater inflater = getLayoutInflater();
        View dialogView = inflater.inflate(R.layout.dialog_layout, null);
        builder.setView(dialogView);

        EditText editTextContent = dialogView.findViewById(R.id.editTextContent);
        EditText editTextFigureId = dialogView.findViewById(R.id.editTextFigureId);

        Button buttonClose = dialogView.findViewById(R.id.buttonClose);

        final AlertDialog dialog = builder.create();

        buttonClose.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String inputText = editTextContent.getText().toString();
                String figureId = editTextFigureId.getText().toString();
                // 处理获取到的输入文本，可以在这里进行相应的操作
                Toast.makeText(SplashActivity.this, "Entered text: " + inputText + " figureId: " + figureId, Toast.LENGTH_SHORT).show();
                startCheckModelActivity(inputText, figureId);
                dialog.dismiss();
                enableButtons(true);
            }
        });

        dialog.show();
    }

    private void startCheckModelActivity(String inputText, String figureId) {
        new Handler(
                msg -> {
                    Intent intent = new Intent(mContext, CheckModelActivity.class);
                    intent.putExtra("useVirtualId", Integer.parseInt(inputText));
                    intent.putExtra("figureId", figureId);
                    startActivity(intent);
                    return false;
                })
                .sendEmptyMessageDelayed(0, 500);
    }


}
