package com.baidu.nlp.conversation.demo.utils;

import android.os.Handler;
import android.os.Message;
import android.text.format.DateFormat;
import android.widget.TextView;

import androidx.annotation.NonNull;

import java.text.SimpleDateFormat;
import java.util.Locale;

public class TimeUtils extends Thread {
    private TextView mTimeTextView;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
    public TimeUtils(TextView timeTextView) {
        mTimeTextView = timeTextView;
    }
    @Override
    public void run() {
        super.run();
        if (mTimeTextView != null) {
            do {
                try {
                    Thread.sleep(1000);
                    Message msg = new Message();
                    // 消息(一个整型值)
                    msg.what = 1;
                    // 每隔1秒发送一个msg给mHandler
                    mHandler.sendMessage(msg);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (true);
        }
    }
    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1:
                    // 获取系统时间
                    long sysTime = System.currentTimeMillis();
                    // 时间显示格式
                    String format = simpleDateFormat.format(sysTime);
                    // 更新时间
                    mTimeTextView.setText(format);
                    break;
                default:
                    break;
            }

        }
    };
}

