package com.baidu.nlp.conversation.demo.utils;

import android.os.Handler;
import android.os.Looper;

/**
     * Utility for interacting with the UI thread.
     */
    public class UiThreadUtil {

        private static Handler sMainHandler = new Handler(Looper.getMainLooper());

        /**
         * @return whether the current thread is the UI thread.
         */
        public static boolean isOnUiThread() {
            return Looper.getMainLooper().getThread() == Thread.currentThread();
        }

        /**
         * Runs the given Runnable on the UI thread.
         */
        public static void runOnUiThread(Runnable runnable) {
            if (runnable == null) {
                return;
            }
            if (isOnUiThread()) {
                runnable.run();
            } else {
                sMainHandler.post(runnable);
            }
        }

        /**
         * 清除所有消息
         */
        public static void removeCallbacksAndMessages() {
            sMainHandler.removeCallbacksAndMessages(null);
        }

        public static void removeCallbacks(Runnable r) {
            sMainHandler.removeCallbacks(r);
        }

        public static void postDelayed(Runnable r, long delayMillis) {
            sMainHandler.postDelayed(r, delayMillis);
        }
}
